//
//  GraphicsViewControllerView.m
//  Drawing Lines
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "GraphicsViewControllerView.h"

@implementation GraphicsViewControllerView

- (id)initWithFrame:(CGRect)frame{
  self = [super initWithFrame:frame];
  if (self) {
    //  Miejsce na kod inicjalizacyjny.
  }
  return self;
}

/* 1 */
//- (void)drawRect:(CGRect)rect{
//  
//  /* Zdefiniowanie koloru, w jakim ma zostać narysowania linia. */
//  [[UIColor brownColor] set];
//  
//  /* Pobranie bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  /* Określenie grubości linii. */
//  CGContextSetLineWidth(currentContext,
//                        5.0f);
//  
//  /* Ustalenie punktu początkowego linii. */
//  CGContextMoveToPoint(currentContext,
//                       50.0f,
//                       10.0f);
//  
//  /* Ustalenie punktu końcowego linii. */
//  CGContextAddLineToPoint(currentContext,
//                          100.0f,
//                          200.0f);
//  
//  /* Użycie aktualnego koloru kontekstu graficznego do narysowania linii. */
//  CGContextStrokePath(currentContext);
//  
//}

/* 2 */
//- (void)drawRect:(CGRect)rect{
//  // Kod odpowiedzialny za rysowanie.
//  
//  /* Zdefiniowanie koloru, w jakim ma zostać narysowania linia. */
//  [[UIColor brownColor] set];
//  
//  /* Pobranie bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  /* Określenie grubości linii. */
//  CGContextSetLineWidth(currentContext,
//                        5.0f);
//  
//  /* Ustalenie punktu początkowego linii. */
//  CGContextMoveToPoint(currentContext,
//                       20.0f,
//                       20.0f);
//  
//  /* Ustalenie punktu końcowego linii. */
//  CGContextAddLineToPoint(currentContext,
//                          100.0f,
//                          100.0f);
//  
//  /* Narysowanie linii do kolejnego punktu. */
//  CGContextAddLineToPoint(currentContext,
//                          300.0f,
//                          100.0f);
//  
//  /* Użycie aktualnego koloru kontekstu graficznego do narysowania linii. */
//  CGContextStrokePath(currentContext);
//  
//}

/* 3 */
- (void) drawRooftopAtTopPointof:(CGPoint)paramTopPoint
                   textToDisplay:(NSString *)paramText
                        lineJoin:(CGLineJoin)paramLineJoin{
  
  /* Zdefiniowanie koloru, w jakim ma zostać narysowania linia. */
  [[UIColor brownColor] set];
  
  /* Pobranie bieżącego kontekstu graficznego. */
  CGContextRef currentContext = UIGraphicsGetCurrentContext();
  
  /* Określenie rodzaju złączenia. */
  CGContextSetLineJoin(currentContext,
                       paramLineJoin);
  
  /* Określenie grubości linii. */
  CGContextSetLineWidth(currentContext,
                        20.0f);
  
  /* Ustalenie punktu początkowego linii. */
  CGContextMoveToPoint(currentContext,
                       paramTopPoint.x - 140,
                       paramTopPoint.y + 100);
  
  /* Ustalenie punktu końcowego linii. */
  CGContextAddLineToPoint(currentContext,
                          paramTopPoint.x,
                          paramTopPoint.y);
  
  /* Narysowanie linii do kolejnego punktu, co spowoduje utworzenie dachu. */
  CGContextAddLineToPoint(currentContext,
                          paramTopPoint.x + 140,
                          paramTopPoint.y + 100);
  
  /* Użycie aktualnego koloru kontekstu graficznego do narysowania linii. */
  CGContextStrokePath(currentContext);
  
  /* Wyświetlenie "w dachu" czarnego tekstu. */
  [[UIColor blackColor] set];
  
  /* Wyświetlenie tekstu. */
  CGPoint drawingPoint = CGPointMake(paramTopPoint.x - 40.0f,
                                     paramTopPoint.y + 60.0f);
  [paramText drawAtPoint:drawingPoint
                withFont:[UIFont boldSystemFontOfSize:30.0f]];
  
}

- (void)drawRect:(CGRect)rect{
  
  [self drawRooftopAtTopPointof:CGPointMake(160.0f, 40.0f)
                  textToDisplay:@"Miter"
                       lineJoin:kCGLineJoinMiter];
  
  [self drawRooftopAtTopPointof:CGPointMake(160.0f, 180.0f)
                  textToDisplay:@"Bevel"
                       lineJoin:kCGLineJoinBevel];
  
  [self drawRooftopAtTopPointof:CGPointMake(160.0f, 320.0f)
                  textToDisplay:@"Round"
                       lineJoin:kCGLineJoinRound];
  
}

@end
